CREATE OR REPLACE FORCE VIEW w83b.w83bresultadodelegcerrar (nacta,
                                                            territ,
                                                            anoacta,
                                                            ver,
                                                            nregdef,
                                                            anoregdef,
                                                            actatotal,
                                                            fechabaja,
                                                            fecharegistro,
                                                            felec,
                                                            codsindicato,
                                                            cif,
                                                            ncentro,
                                                            razon,
                                                            numdelegados,
                                                            nueva
                                                           )
AS
   SELECT   actas.n_acta_016 AS nacta, actas.c_territ_016 AS territ,
            actas.ano_acta_016 AS anoacta, actas.version_016 AS ver,
            actas.n_regdef_016 AS nregdef, actas.ano_regdef_016 AS anoregdef,
            actas.n_acttot_016 AS actatotal, actas.f_baja_016 AS fechabaja,
            actas.fregdef_016 AS fecharegistro, actas.f_elecc_016 AS felec,
            escrutinios.c_sindi_024 AS codsindicato, centros.ccif_001 AS cif,
            centros.ncen_001 AS ncentro, centros.rsoc_001 AS razon,
            SUM (escrutinios.n_delh_024 + escrutinios.n_delm_024),
            actas.nueva_016 AS nueva
       FROM w83b16s00 actas, w83b24s00 escrutinios, j7301s01 centros
      WHERE actas.n_acta_016 = escrutinios.n_acta_024(+)
        AND actas.ano_acta_016 = escrutinios.ano_acta_024(+)
        AND actas.c_territ_016 = escrutinios.c_territ_024(+)
        AND actas.version_016 = escrutinios.version_024(+)
        AND centros.ccen_001 = actas.id_centro_016
        AND actas.nueva_016 = 0
        AND actas.validada_016 = 1
        AND actas.n_regdef_016 IS NOT NULL
        AND actas.n_acttot_016 IS NULL
   GROUP BY actas.n_acta_016,
            actas.c_territ_016,
            actas.ano_acta_016,
            actas.version_016,
            actas.n_acttot_016,
            actas.f_baja_016,
            actas.fregdef_016,
            actas.f_elecc_016,
            escrutinios.c_sindi_024,
            centros.ccif_001,
            centros.ncen_001,
            centros.rsoc_001,
            actas.n_regdef_016,
            actas.ano_regdef_016,
            actas.nueva_016
   ORDER BY nacta, territ, anoacta, ver, codsindicato;
/